/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWWorkClassProxy;
import filenet.vw.toolkit.design.property.tables.VWFieldNameCellEditor;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextField;

public class VWAdvancedFieldNameCellEditor
extends VWFieldNameCellEditor {
    private boolean m_bCurrentPrimary = true;
    private VWWorkClassProxy m_workClassProxy = null;

    public VWAdvancedFieldNameCellEditor(VWAuthPropertyData authPropertyData, boolean bIsPrimary) {
        super(authPropertyData);
        this.m_bCurrentPrimary = bIsPrimary;
    }

    public void setWorkClassProxy(VWWorkClassProxy workClassProxy) {
        this.m_workClassProxy = workClassProxy;
        this.initFieldListComboBox();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.initFieldListComboBox();
        if (value != null && value instanceof String) {
            this.setValue(value);
        }
        if (this.m_combo != null) {
            this.m_combo.setComponentOrientation(table.getComponentOrientation());
            if (this.m_editor.getEditorComponent() instanceof JTextField) {
                ((JTextField)this.m_editor.getEditorComponent()).setComponentOrientation(table.getComponentOrientation());
            }
        }
        return this.m_combo;
    }

    private void initFieldListComboBox() {
        if (this.m_authPropertyData != null && this.m_combo != null) {
            VWWorkflowSignature signature;
            Object[] currentFields = null;
            VWFieldDefinition[] otherFields = null;
            Object[] primaryFields = null;
            Object[] secondaryFields = null;
            this.m_combo.removeAllItems();
            currentFields = this.m_authPropertyData.getFields();
            if (this.m_workClassProxy != null && this.m_workClassProxy.getWorkflowSignature() != null && (signature = this.m_workClassProxy.getWorkflowSignature()) != null) {
                otherFields = signature.getFieldDefinitions();
            }
            if (this.m_bCurrentPrimary) {
                primaryFields = currentFields;
                secondaryFields = otherFields;
            } else {
                secondaryFields = currentFields;
                primaryFields = otherFields;
            }
            if (primaryFields != null || secondaryFields != null) {
                try {
                    String name;
                    if (primaryFields != null && primaryFields.length > 0) {
                        VWQubbleSort.sort(primaryFields);
                        for (int i = 0; i < primaryFields.length; ++i) {
                            if (primaryFields[i] == null || (name = ((VWFieldDefinition)primaryFields[i]).getName()) == null || name.startsWith("F_")) continue;
                            this.m_combo.addItem(name);
                        }
                    }
                    if (secondaryFields != null && secondaryFields.length > 0) {
                        VWQubbleSort.sort(secondaryFields);
                        for (int i = 0; i < secondaryFields.length; ++i) {
                            if (secondaryFields[i] == null || (name = ((VWFieldDefinition)secondaryFields[i]).getName()) == null || name.startsWith("F_")) continue;
                            this.m_combo.addItem("$" + name);
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.m_combo.setSelectedIndex(-1);
        }
    }
}

